#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_VbecsUser : BaseTest 
	{
		
		private DataTable _dtUser;
		private DataTable _dtUserDivRole;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			RestoreActiveRecords();

			if (this.RefreshData)
				RefreshTestData();
		}

		private void RestoreActiveRecords()
		{
			UnitTestUtil.RunSQL( "update VbecsUser set RecordStatusCode = 'A'; update VbecsUserDivisionRole set RecordStatusCode = 'A';" );
		}

		private void RefreshTestData()
		{			
			this._dtUser = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VbecsUser WHERE VbecsUserId = 'VHAISHVBECS1'"); //Hardcoding for speed
			this._dtUserDivRole = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VbecsUserDivisionRole WHERE VbecsUserId = 'VHAISHVBECS1'");	//Hardcoding for speed

			this.RefreshData = false;
		}

		private string GetTestUserId()
		{
			return _dtUser.Rows[0][TABLES.VbecsUser.VbecsUserId].ToString();
		}

		[Test]
		public void GetRequireVbecsUser_Pass()
		{
			VerifyGetVbecsUserDataRow( DAL.VbecsUser.GetRequireVbecsUser( GetTestUserId(), false ).Rows[0] );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetRequireVbecsUser_Fail()
		{
			DAL.VbecsUser.GetRequireVbecsUser( null, false );
		}

		[Test]
		public void GetCheckForVbecsUser_Pass_1()
		{
			VerifyGetVbecsUserDataRow( DAL.VbecsUser.GetCheckForVbecsUser( GetTestUserId() ) );
		}

		[Test]
		public void GetCheckForVbecsUser_Pass_2()
		{
			Assert.IsNull( DAL.VbecsUser.GetCheckForVbecsUser( Guid.NewGuid().ToString() ) );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetCheckForVbecsUser_Fail()
		{
			//TODO: Remove code in DAL.VbecsUser - catch for InsufficientNumberOfDataRowsFoundWhileExpectingSingleRow can never be reached
			//because the stored procedure does a search on the primary key
			DAL.VbecsUser.GetCheckForVbecsUser( null );
		}

		[Test]
		public void GetAllUsers_Pass()
		{
			DataTable dtTest = DAL.VbecsUser.GetAllUsers();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserId), TABLES.VbecsUser.VbecsUserId );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserGuid), TABLES.VbecsUser.VbecsUserGuid );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserDUZ), TABLES.VbecsUser.UserDUZ );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserName), TABLES.VbecsUser.UserName );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VistaUserName), TABLES.VbecsUser.VistaUserName );
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserInitials), TABLES.VbecsUser.UserInitials );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserEmail), TABLES.VbecsUser.UserEmail );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RecordStatusCode), TABLES.VbecsUser.RecordStatusCode );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.LastUpdateUser), TABLES.VbecsUser.LastUpdateUser );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.LastUpdateDate), TABLES.VbecsUser.LastUpdateDate );
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RowVersion), TABLES.VbecsUser.RowVersion );
		}	

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllUsers_Fail() {}	



		[Test]
		public void PersistUsers_Pass()
		{
			this.RefreshData = true;

			DataTable dtDataUser = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsUser WHERE VbecsUserId = '" + Common.LogonUser.LogonUserName + "'",true);
			DataTable dtUser = SprocHelper.GetUpdateVbecsUserSprocTable(System.Guid.NewGuid(), "temp", new byte[8]);
			
			foreach(DataColumn dc in dtDataUser.Columns)
			{
				if (dtUser.Columns.Contains(dc.ColumnName))
				{
					dtUser.Rows[0][dc.ColumnName] = dtDataUser.Rows[0][dc.ColumnName];
				}
			}

			DataTable dtDataRole = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsUserDivisionRole WHERE VbecsUserId = '" + Common.LogonUser.LogonUserName + "'", true);
			DataTable dtRole = DAL.VbecsUser.GetVbecsUserDivisionRoleSaveTemplateDataTable();

			if (dtDataRole.Rows.Count > 1)
			{
				UnitTestUtil.RunSQL("DELETE FROM VbecsUserDivisionRole WHERE VbecsUserId = '" + Common.LogonUser.LogonUserName + "' AND DivisionCode <> '" + this.TestDivisionCode + "'");
				dtDataRole = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsUserDivisionRole WHERE VbecsUserId = '" + Common.LogonUser.LogonUserName + "'", true);
			}

			foreach(DataRow dr in dtDataRole.Rows)
			{
				DataRow drUpdRole = dtRole.NewRow();
				foreach(DataColumn dc in dtDataRole.Columns)
				{
					if (dtRole.Columns.Contains(dc.ColumnName))
					{
						drUpdRole[dc.ColumnName] = dr[dc.ColumnName];
					}
				}
				dtRole.Rows.Add(drUpdRole);
			}

			//Create a Insert record for code coverage
			DataRow drIns = dtRole.NewRow();
			drIns[TABLES.VbecsUserDivisionRole.VbecsUserId] = Common.LogonUser.LogonUserName;
			drIns[TABLES.VbecsUserDivisionRole.DivisionCode] = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 DivisionCode FROM VamcDivision WHERE DivisionCode <> '" + this.TestDivisionCode + "'")[TABLES.VamcDivision.DivisionCode].ToString();
			drIns[TABLES.VbecsUserDivisionRole.UserRoleId] = (int)Common.UserRoleType.AdministratorSupervisor;
			drIns[TABLES.VbecsUserDivisionRole.RecordStatusCode] = "A";
			drIns[TABLES.VbecsUserDivisionRole.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dtRole.Rows.Add(drIns);

			System.Collections.IList rolesArray = new System.Collections.ArrayList();
			rolesArray.Add(dtRole);
			DAL.VbecsUser.PersistUsers(dtUser, rolesArray, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, true, "ReturnValue");
		}

		[Test]
		public void PersistUsers_Fail()
		{
			this.RefreshData = true;

			try
			{
				DataTable dtDataUser = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsUser WHERE VbecsUserId = '" + Common.LogonUser.LogonUserName + "'",true);
				DataTable dtUser = SprocHelper.GetUpdateVbecsUserSprocTable(System.Guid.NewGuid(), "temp", new byte[8]);
			
				foreach(DataColumn dc in dtDataUser.Columns)
				{
					if (dtUser.Columns.Contains(dc.ColumnName))
					{
						dtUser.Rows[0][dc.ColumnName] = dtDataUser.Rows[0][dc.ColumnName];
					}
					if (dc.ColumnName == TABLES.VbecsUser.RowVersion)
					{
						dtUser.Rows[0][dc.ColumnName] = new byte[8];
					}
				}

				dtUser.Rows[0][TABLES.VbecsUser.RowVersion] = new byte[8];

				DataTable dtDataRole = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsUserDivisionRole WHERE VbecsUserId = '" + Common.LogonUser.LogonUserName + "' AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				DataTable dtRole = DAL.VbecsUser.GetVbecsUserDivisionRoleSaveTemplateDataTable();

				foreach(DataRow dr in dtDataRole.Rows)
				{
					DataRow drUpdRole = dtRole.NewRow();
					foreach(DataColumn dc in dtDataRole.Columns)
					{
						if (dtRole.Columns.Contains(dc.ColumnName))
						{
							drUpdRole[dc.ColumnName] = dr[dc.ColumnName];
						}
						if (dc.ColumnName == TABLES.UserRoleFunction.RowVersion)
						{
							drUpdRole[dc.ColumnName] = new byte[8];
						}
					}
					dtRole.Rows.Add(drUpdRole);
				}

				System.Collections.IList rolesArray = new System.Collections.ArrayList();
				rolesArray.Add(dtRole);
				DAL.VbecsUser.PersistUsers(dtUser, rolesArray, Common.UpdateFunction.UnitTests);

				Assert.Fail("RowVersionException expected");
			}
			catch(Common.RowVersionException)
			{
				Assert.IsTrue(true, "RowVersionExcpetion");
			}

			//TODO: Can remove ArgumentNull excpetions in ExecuteVbecsUserSaveActions - code always passes in fresh collectionarrays

			//Trap for Unique Constraint on VbecsUserId field
			try
			{
				DataTable dtUser = DAL.VbecsUser.GetUserTemplateDataTable();
				DataRow dr = dtUser.NewRow();

				string currentUser = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 VbecsUserId FROM VbecsUser")[TABLES.VbecsUser.VbecsUserId].ToString();

				dr[TABLES.VbecsUser.VbecsUserId] = currentUser;
				dr[TABLES.VbecsUser.VbecsUserGuid] = System.Guid.NewGuid();
				dr[TABLES.VbecsUser.UserDUZ] = new Random().Next(111111,999999).ToString();
				dr[TABLES.VbecsUser.UserName] = "Simpson";
				dr[TABLES.VbecsUser.UserInitials] = new Random().Next(111,999).ToString();
				dr[TABLES.VbecsUser.VistaUserName] = System.DateTime.Now.ToString();
				dr[TABLES.VbecsUser.UserEmail] = "chunkylover55@yahoo.com";
				dr[TABLES.VbecsUser.RecordStatusCode] = "A";
				dr[TABLES.VbecsUser.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
				dtUser.Rows.Add(dr);

				DAL.VbecsUser.PersistUsers(dtUser, new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);
				
				Assert.Fail("UniqueDatabaseConstraintViolatedException on VbecsUserId expected");
			}
            catch (Common.UniqueDatabaseConstraintViolatedException)
			{
				Assert.IsTrue(true,"UniqueDatabaseConstraintViolatedException - VbecsUserId");
			}

			//Trap for Unique Constraint on UserDUZ field
			try
			{
				DataTable dtUser = DAL.VbecsUser.GetUserTemplateDataTable();
				DataRow dr = dtUser.NewRow();

				string currentDUZ = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 UserDUZ FROM VbecsUser")[TABLES.VbecsUser.UserDUZ].ToString();

				dr[TABLES.VbecsUser.VbecsUserId] = System.DateTime.Now.ToString();
				dr[TABLES.VbecsUser.VbecsUserGuid] = System.Guid.NewGuid();
				dr[TABLES.VbecsUser.UserDUZ] = currentDUZ;
				dr[TABLES.VbecsUser.UserName] = "Simpson";
				dr[TABLES.VbecsUser.UserInitials] = new Random().Next(111,999).ToString();
				dr[TABLES.VbecsUser.VistaUserName] = System.DateTime.Now.ToString();
				dr[TABLES.VbecsUser.UserEmail] = "chunkylover55@yahoo.com";
				dr[TABLES.VbecsUser.RecordStatusCode] = "A";
				dr[TABLES.VbecsUser.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
				dtUser.Rows.Add(dr);

				DAL.VbecsUser.PersistUsers(dtUser, new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);
				
				Assert.Fail("UniqueDatabaseConstraintViolatedException on UserDUZ expected");
			}
            catch (Common.UniqueDatabaseConstraintViolatedException)
			{
				Assert.IsTrue(true,"UniqueDatabaseConstraintViolatedException - UserDUZ");
			}

			//Trap for Unique Constraint on UserInitials field
			try
			{
				DataTable dtUser = DAL.VbecsUser.GetUserTemplateDataTable();
				DataRow dr = dtUser.NewRow();

				string currentInitials = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 UserInitials FROM VbecsUser")[TABLES.VbecsUser.UserInitials].ToString();

				dr[TABLES.VbecsUser.VbecsUserId] = System.DateTime.Now.ToString();
				dr[TABLES.VbecsUser.VbecsUserGuid] = System.Guid.NewGuid();
				dr[TABLES.VbecsUser.UserDUZ] = new Random().Next(111111,999999).ToString();
				dr[TABLES.VbecsUser.UserName] = "Simpson";
				dr[TABLES.VbecsUser.UserInitials] = currentInitials;
				dr[TABLES.VbecsUser.VistaUserName] = System.DateTime.Now.ToString();
				dr[TABLES.VbecsUser.UserEmail] = "chunkylover55@yahoo.com";
				dr[TABLES.VbecsUser.RecordStatusCode] = "A";
				dr[TABLES.VbecsUser.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
				dtUser.Rows.Add(dr);

				DAL.VbecsUser.PersistUsers(dtUser, new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);
				
				Assert.Fail("UniqueDatabaseConstraintViolatedException on UserInitials expected");
			}
            catch (Common.UniqueDatabaseConstraintViolatedException)
			{
				Assert.IsTrue(true,"UniqueDatabaseConstraintViolatedException - UserInitials");
			}


			//Trap for Unique Constraint on UserInitials field
			try
			{
				DataTable dtUser = DAL.VbecsUser.GetUserTemplateDataTable();
				DataRow dr = dtUser.NewRow();

				string currentVistaUserName = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 VistaUserName FROM VbecsUser")[TABLES.VbecsUser.VistaUserName].ToString();

				dr[TABLES.VbecsUser.VbecsUserId] = System.DateTime.Now.ToString();
				dr[TABLES.VbecsUser.VbecsUserGuid] = System.Guid.NewGuid();
				dr[TABLES.VbecsUser.UserDUZ] = new Random().Next(111111,999999).ToString();
				dr[TABLES.VbecsUser.UserName] = "Simpson";
				dr[TABLES.VbecsUser.UserInitials] = new Random().Next(111,999).ToString();
				dr[TABLES.VbecsUser.VistaUserName] = currentVistaUserName;
				dr[TABLES.VbecsUser.UserEmail] = "chunkylover55@yahoo.com";
				dr[TABLES.VbecsUser.RecordStatusCode] = "A";
				dr[TABLES.VbecsUser.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
				dtUser.Rows.Add(dr);

				DAL.VbecsUser.PersistUsers(dtUser, new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);
				
				Assert.Fail("UniqueDatabaseConstraintViolatedException on VistaUserName expected");
			}
            catch (Common.UniqueDatabaseConstraintViolatedException)
			{
				Assert.IsTrue(true,"UniqueDatabaseConstraintViolatedException - VistaUserName");
			}


			//Catch ArgumentNullException in AddVbecsUsersListSaveActions for user data
			try
			{
				DAL.VbecsUser.PersistUsers(null, new System.Collections.ArrayList(), Common.UpdateFunction.UnitTests);
				Assert.Fail("ArgumentException for Null user data expected");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true, "Null user data");
			}

			//Catch ArgumentNullException in AddVbecsUsersListSaveActions for roles data
			try
			{
				DAL.VbecsUser.PersistUsers(new DataTable(), null, Common.UpdateFunction.UnitTests);
				Assert.Fail("ArgumentException for Null role data expected");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true, "Null role data");
			}
		}

		[Test]
		public void GetVbecsUserPermissions_Pass()
		{
			DataTable dtTest = DAL.VbecsUser.GetVbecsUserPermissions( GetTestUserId() );
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserId), TABLES.VbecsUser.VbecsUserId );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserName), TABLES.VbecsUser.UserName );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUserDivisionRole.DivisionCode), TABLES.VbecsUserDivisionRole.DivisionCode );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RecordStatusCode), TABLES.VbecsUser.RecordStatusCode );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.UserRoleId), TABLES.UserRole.UserRoleId );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.UserRoleName), TABLES.UserRole.UserRoleName );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RoleFunction.RoleFunctionId), TABLES.RoleFunction.RoleFunctionId );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RoleFunction.RoleFunctionText), TABLES.RoleFunction.RoleFunctionText );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetVbecsUserPermissions_Fail()
		{
			DAL.VbecsUser.GetVbecsUserPermissions( null );
		}

//TODO: Remove 'internal static void AddVbecsUserSaveActions' from DAL.VbecsUser -- method never used
//TODO: Parameter checks for null can be removed - its unreachable code since they're checked for null in all previous methods - DAL.VbecsUser.AddVbecsUserCoreSaveActions()
//TODO: Parameter checks for null can be removed - its unreachable code since they're checked for null in all previous methods - DAL.VbecsUser.AddVbecsUserDivisionRoleSaveActions()

		[Test]
		public void GetVbecsUserDivisionsAndRoles_Pass()
		{
			DataTable _dtRoles = VbecsUser.GetVbecsUserDivisionsAndRoles( GetTestUserId() );

			Assert.AreEqual(true, _dtRoles.Rows.Count > 0, "Rows.Count" );
			Assert.AreEqual(40, _dtRoles.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.DivisionCode), TABLES.VamcDivision.DivisionCode );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.DivisionGuid), TABLES.VamcDivision.DivisionGuid );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.DivisionName), TABLES.VamcDivision.DivisionName );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.ServiceTypeIndicator), TABLES.VamcDivision.ServiceTypeIndicator );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.IccbbaRegistrationNumber), TABLES.VamcDivision.IccbbaRegistrationNumber );

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.ElectronicCrossmatchIndicator), TABLES.VamcDivision.ElectronicCrossmatchIndicator );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.FacilityGuid), TABLES.VamcDivision.FacilityGuid );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.AccessionAreaId), TABLES.VamcDivision.AccessionAreaId );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.LocalSupplierGuid ), TABLES.VamcDivision.LocalSupplierGuid);
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.AntibodyScreenDisplayCode), TABLES.VamcDivision.AntibodyScreenDisplayCode );

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.MaximumSpecimenExpirationDays), TABLES.VamcDivision.MaximumSpecimenExpirationDays );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.AutomatedInstrumentIndicator), TABLES.VamcDivision.AutomatedInstrumentIndicator );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.LabelPrinterUseIndicator), TABLES.VamcDivision.LabelPrinterUseIndicator );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.LabelPrinterComPortNumber), TABLES.VamcDivision.LabelPrinterComPortNumber );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.LabelPrinterIPAddress), TABLES.VamcDivision.LabelPrinterIPAddress );

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.LabelPrinterTcpPortNumber), TABLES.VamcDivision.LabelPrinterTcpPortNumber );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.TimeZoneId), TABLES.VamcDivision.TimeZoneId );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.DaylightSavingsTypeId), TABLES.VamcDivision.DaylightSavingsTypeId );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.DaylightSavingsStartDate), TABLES.VamcDivision.DaylightSavingsStartDate );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.DaylightSavingsEndDate), TABLES.VamcDivision.DaylightSavingsEndDate );

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.PrinterAlertsIndicator), TABLES.VamcDivision.PrinterAlertsIndicator );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.PrinterAlertsPrinterName), TABLES.VamcDivision.PrinterAlertsPrinterName );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.PrinterOrderAlertTypeCode), TABLES.VamcDivision.PrinterOrderAlertTypeCode );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.PrinterOrdersNeededHours), TABLES.VamcDivision.PrinterOrdersNeededHours );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.IconAlertsIndicator), TABLES.VamcDivision.IconAlertsIndicator );

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.IconOrderAlertTypeCode), TABLES.VamcDivision.IconOrderAlertTypeCode );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.IconOrdersNeededHours), TABLES.VamcDivision.IconOrdersNeededHours );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.IconRefreshRate), TABLES.VamcDivision.IconRefreshRate );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.LoginMessageText), TABLES.VamcDivision.LoginMessageText );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.InvoiceTemplateText), TABLES.VamcDivision.InvoiceTemplateText );

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.MedicalDirectorName), TABLES.VamcDivision.MedicalDirectorName );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.LockInactivityTimeoutMin), TABLES.VamcDivision.LockInactivityTimeoutMin );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.RecordStatusCode), TABLES.VamcDivision.RecordStatusCode );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.VamcDivision.RowVersion), TABLES.VamcDivision.RowVersion );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.UserRole.UserRoleId), TABLES.UserRole.UserRoleId );

			Assert.AreEqual(true, _dtRoles.Columns.Contains(TABLES.UserRole.UserRoleName), TABLES.UserRole.UserRoleName );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(ARTIFICIAL.UserDivisionRoleRecordStatusCode), ARTIFICIAL.UserDivisionRoleRecordStatusCode );
			Assert.AreEqual(true, _dtRoles.Columns.Contains(ARTIFICIAL.UserDivisionRoleRowVersion), ARTIFICIAL.UserDivisionRoleRowVersion );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetVbecsUserDivisionsAndRoles_Fail()
		{
			VbecsUser.GetVbecsUserDivisionsAndRoles( null );
		}

		[Test]
		public void GetUserRolesList_Pass()
		{
			DataTable dtTest = DAL.VbecsUser.GetUserRolesList((int)Common.UserRoleType.AdministratorSupervisor);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.UserRoleId), TABLES.UserRole.UserRoleId );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.UserRoleName), TABLES.UserRole.UserRoleName );
		}

		[Test]
		public void GetUserRolesList_Fail()
		{
			DataTable _dtTest = DAL.VbecsUser.GetUserRolesList( -8 );
		
			Assert.AreEqual(0, _dtTest.Rows.Count, "Rows.Count" );
		}


		[Test]
		public void GetActiveDivisionUsers_Pass()
		{
			DataTable dtTest = DAL.VbecsUser.GetActiveDivisionUsers( UnitTestConfig.TestDivisionCode );

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserId), TABLES.VbecsUser.VbecsUserId );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserGuid), TABLES.VbecsUser.VbecsUserGuid );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserDUZ), TABLES.VbecsUser.UserDUZ );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserName), TABLES.VbecsUser.UserName );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VistaUserName), TABLES.VbecsUser.VistaUserName );
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserInitials), TABLES.VbecsUser.UserInitials );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserEmail), TABLES.VbecsUser.UserEmail );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RecordStatusCode), TABLES.VbecsUser.RecordStatusCode );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.LastUpdateUser), TABLES.VbecsUser.LastUpdateUser );
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.LastUpdateDate), TABLES.VbecsUser.LastUpdateDate );
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RowVersion), TABLES.VbecsUser.RowVersion );
		}

		[Test]
		public void GetActiveDivisionUsers_Fail()
		{
			try
			{
				DAL.VbecsUser.GetActiveDivisionUsers( null );
				Assert.Fail( AssertionFailReasons.ArgumentExceptionExpected );
			}
			catch( ArgumentException ) 
			{
				Assert.IsTrue(true, "Step1");
			}

			try
			{
				DAL.VbecsUser.GetActiveDivisionUsers( string.Empty );
				Assert.Fail( AssertionFailReasons.ArgumentExceptionExpected );
			}
			catch( ArgumentException )
			{
				Assert.IsTrue(true, "Step2");
			}
		}


		[Test]
		public void GetVbecsUsersWithRoleInGivenDivision_Pass()
		{
			DataTable dtTest = DAL.VbecsUser.GetVbecsUsersWithRoleInGivenDivision(this.TestDivisionCode);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserId), TABLES.VbecsUser.VbecsUserId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserGuid), TABLES.VbecsUser.VbecsUserGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserDUZ), TABLES.VbecsUser.UserDUZ);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserName), TABLES.VbecsUser.UserName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VistaUserName), TABLES.VbecsUser.VistaUserName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserInitials), TABLES.VbecsUser.UserInitials);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserEmail), TABLES.VbecsUser.UserEmail);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RecordStatusCode), TABLES.VbecsUser.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.LastUpdateUser), TABLES.VbecsUser.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.LastUpdateDate), TABLES.VbecsUser.LastUpdateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RowVersion), TABLES.VbecsUser.RowVersion);
		}


		[Test]
		public void GetVbecsUsersWithRoleInGivenDivision_Fail()
		{
			DataTable dtTest = DAL.VbecsUser.GetVbecsUsersWithRoleInGivenDivision("plop");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetVbecsUserDivisionRoleSaveTemplateDataTable_Pass()
		{
			DataTable dtTest = DAL.VbecsUser.GetVbecsUserDivisionRoleSaveTemplateDataTable();

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUserDivisionRole.VbecsUserId), TABLES.VbecsUserDivisionRole.VbecsUserId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUserDivisionRole.DivisionCode), TABLES.VbecsUserDivisionRole.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUserDivisionRole.UserRoleId), TABLES.VbecsUserDivisionRole.UserRoleId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUserDivisionRole.RowVersion), TABLES.VbecsUserDivisionRole.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUserDivisionRole.RecordStatusCode), TABLES.VbecsUserDivisionRole.RecordStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUserDivisionRole.LastUpdateFunctionId), TABLES.VbecsUserDivisionRole.LastUpdateFunctionId);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetVbecsUserDivisionRoleSaveTemplateDataTable_Fail()
		{
		}

		[Test]
		public void GetUserTemplateDataTable_Pass()
		{
			DataTable dtTest = DAL.VbecsUser.GetUserTemplateDataTable();

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserId), TABLES.VbecsUser.VbecsUserId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VbecsUserGuid), TABLES.VbecsUser.VbecsUserGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserDUZ), TABLES.VbecsUser.UserDUZ);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserName), TABLES.VbecsUser.UserName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.VistaUserName), TABLES.VbecsUser.VistaUserName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserInitials), TABLES.VbecsUser.UserInitials);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserEmail), TABLES.VbecsUser.UserEmail);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RecordStatusCode), TABLES.VbecsUser.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.RowVersion), TABLES.VbecsUser.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.LastUpdateFunctionId), TABLES.VbecsUser.LastUpdateFunctionId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetUserTemplateDataTable_Fail()
		{
		}

		
		/// <summary>
		/// Code reuse to validate the tables
		/// </summary>
		/// <param name="drUser"></param>
		private void VerifyGetVbecsUserDataRow( DataRow drUser )
		{
			Assert.AreEqual(11, drUser.Table.Columns.Count,"Columns.Count");

			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.VbecsUserId ), TABLES.VbecsUser.VbecsUserId );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.VbecsUserGuid ), TABLES.VbecsUser.VbecsUserGuid );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.UserDUZ ), TABLES.VbecsUser.UserDUZ );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.UserName ), TABLES.VbecsUser.UserName );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.VistaUserName ), TABLES.VbecsUser.VistaUserName );
			
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.UserInitials ), TABLES.VbecsUser.UserInitials );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.UserEmail ), TABLES.VbecsUser.UserEmail );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.RecordStatusCode ), TABLES.VbecsUser.RecordStatusCode );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.LastUpdateDate ), TABLES.VbecsUser.LastUpdateDate );
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.LastUpdateUser ), TABLES.VbecsUser.LastUpdateUser );
			
			Assert.AreEqual(true, drUser.Table.Columns.Contains( TABLES.VbecsUser.RowVersion ), TABLES.VbecsUser.RowVersion );
		}

	}
}
#endif
